﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Security.Cryptography;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class IntensiveLogging
    {/*
        public static void LogMethodStart(String methodName)
        {
            LogMethodStart(methodName, null);
        }
        public static void LogMethodStart(String methodName, String details)
        {
            if (!String.IsNullOrEmpty(AHOBPRGlobal.IntensiveLoggingFileName))
            {
                LogMessageToFile(DateTime.Now.ToString() + ":\tS " + methodName + "\r\n");
                if (!String.IsNullOrEmpty(details))
                {
                    LogMessageToFile("\t\t\t" + details + "\r\n");
                }
            }
        }
        public static void LogMethodStop(String methodName)
        {
            if (!String.IsNullOrEmpty(AHOBPRGlobal.IntensiveLoggingFileName))
            {
                LogMessageToFile(DateTime.Now.ToString() + ":\tT" + methodName + "\r\n");
            }
        }*/

        public static void LogErrorMessage(string errorType, string errorSource, string errorMessage)
        {
            //Remove PII from the error message (if present):
            int index = errorMessage.IndexOf("},{data:");
            if (index > 0)
            {
                errorMessage = errorMessage.Substring(0, index);
            }
            LogMessageToFile("Exception: " + DateTime.Now.ToString());
            LogMessageToFile("\t" + errorType + "\r\n");
            LogMessageToFile("\t " + errorSource + "\r\n");
            LogMessageToFile("\t " + errorMessage + "\r\n");
        }

        private static void LogMessageToFile(string message)
        {
            String fileName = ValidateFileName(AHOBPRGlobal.IntensiveLoggingFileName);
            if (!string.IsNullOrEmpty(fileName))
            {
                try
                {
                    byte finalNumber;

                    using (RNGCryptoServiceProvider rngCsp = new RNGCryptoServiceProvider())
                    {
                        int[] results = new int[5];
                        byte numRange = (byte)results.Length;
                        byte[] randomNumber = new byte[1];
                        do
                        {
                            rngCsp.GetBytes(randomNumber);
                        }
                        while (!IsValidNumber(randomNumber[0], numRange));

                        finalNumber = (byte)((randomNumber[0] % numRange) + 1);
                    }

                    if (finalNumber == 4)
                    {
                        Manage();
                    }
                    File.AppendAllText(fileName, message);
                }
                catch (Exception){ throw; }
            }
        }

        private static bool IsValidNumber(byte val, byte numRange)
        {
            int fullSetsOfValues = Byte.MaxValue / numRange;

            return val < numRange * fullSetsOfValues;
        }

        /// <summary>
        /// If the log file is too large, it will have performance impact for the SQL Transporter. To solve this problem,
        /// we will rename the log file from AWARE_SQL_Transporter.log to AWARE_SQL_Transporter_yyyyMMddhhmmss.log when its size > set size (configurable value)
        /// 
        /// We also want to only keep the last x (configurable value) number of the log files to prevent the disk space full issue.
        /// </summary>
        private static void Manage()
        {
            string fileName = ValidateFileName(AHOBPRGlobal.IntensiveLoggingFileName);

            // rename the log file if it's size exceeds the max size allowed
            FileInfo file = new FileInfo(fileName);
            long logFileSize = 0;
            string archivedLogFileFolder = Directory.GetCurrentDirectory() + Path.DirectorySeparatorChar.ToString() + "archive" + Path.DirectorySeparatorChar.ToString();

            // if the log file does not exist yet, the file size is 0
            try
            {
                logFileSize = file.Length;
            }
            catch
            {
                logFileSize = 0;
            }
            if (logFileSize > Convert.ToInt64(500) * 1000000)
            {
                if (!Directory.Exists(archivedLogFileFolder))
                {
                    Directory.CreateDirectory(archivedLogFileFolder);
                }

                File.Move(fileName, archivedLogFileFolder + Path.DirectorySeparatorChar.ToString() + fileName.Replace(".log", "_" + DateTime.Now.ToString("yyyyMMddhhmmss") + ".log"));
            }

            // Delete the oldest log file if the number of the log files exceeds the maximum number of log files allowed.
            if (Directory.Exists(archivedLogFileFolder))
            {
                int numberOfLogFilesToKeep = Convert.ToInt32(4);
                var files = new DirectoryInfo(archivedLogFileFolder).GetFiles()
                    .Where(f => f.FullName.EndsWith(".log"))
                    .OrderByDescending(f => f.LastWriteTime)
                    .Skip(numberOfLogFilesToKeep)
                    .ToList();

                files.ForEach(f => f.Delete());
            }
        }

        //private static long GetFreeDiskSpace()
        //{
        //    return new DriveInfo(Path.GetPathRoot(System.Diagnostics.Process.GetCurrentProcess().MainModule.FileName).Substring(0, 1)).AvailableFreeSpace;
        //}

        /// <summary>
        /// ValidateFileName and white list added for Fortify
        /// </summary>
        /// <param name="fileName"></param>
        /// <returns></returns>
        private static string ValidateFileName(string fileName)
        {
            string[] whiteList = {
                        "D:\\AHOBPR_REST_Service.log"
                        ,"D:\\AHOBPR\\Job Runner\\AHOBPR_REST_Service.log"
                        ,"D:\\AHOBPR Job Runner\\AHOBPR_REST_Service.log"
                        ,"D:\\AHOBPR Job Runner\\PreProd\\AHOBPR_REST_Service.log"};

            if (whiteList.Contains(fileName))
                return fileName;
            else
                return "C:\\AHOBPR_REST_Service.log";
        }
    }
}
